(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8754,        255]*)
(*NotebookOutlinePosition[      9460,        280]*)
(*  CellTagsIndexPosition[      9416,        276]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Iteraciones funcionales", "Title"],

Cell[CellGroupData[{

Cell["Descripci\[OAcute]n de la pr\[AAcute]ctica", "Section"],

Cell[TextData[{
  "En esta pr\[AAcute]ctica vamos a estudiar iteraciones de punto fijo pero \
en las que se itera un operador que act\[UAcute]a sobre funciones. Por tanto \
las sucesiones que resultan son sucesiones de funciones. Este es un \
procedimiento corriente para calcular soluciones aproximadas de ecuaciones \
funcionales (se llaman as\[IAcute] las ecuaciones en las que la \
inc\[OAcute]gnita es una funci\[OAcute]n). Hay que destacar las llamadas ",
  StyleBox["iteraciones de Picard ",
    FontSlant->"Italic"],
  "para obtener",
  StyleBox[" ",
    FontSlant->"Italic"],
  "soluciones aaproximadas (exactas en el l\[IAcute]mite) de problemas de \
valores iniciales de una ecuaci\[OAcute]n diferencial ordinaria."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Subsubsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n \"F[func_]\" que act\[UAcute]a sobre una funci\
\[OAcute]n \"func\"",
  " y la convierte en la funci\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`\(F[func]\)[x] = x - \ func[1.0 - x]/3\)]],
  " (consulta el comando \"Function\" en la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). \n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Partiendo de la funci\[OAcute]n identidad \"Identity\" itera la funci\
\[OAcute]n antes definida 15 veces. Representa gr\[AAcute]ficamente las \
funciones as\[IAcute] obtenidas en el intervalo [-10,10]. \
\[DownQuestion]Converge la sucesi\[OAcute]n de iteradas as\[IAcute] definida? \
Repite el proceso anterior partiendo inicialmente de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[x] = x\^2\)]],
  ". Comenta los resultados obtenidos.\nSugerencias: Es conveniente usar \
\"Table\", \"Simplify\" y \"Nest\" en vez de \"NestList\" que no va bien para \
lo que queremos. \n",
  StyleBox["c)",
    FontWeight->"Bold"],
  "  Define una funci\[OAcute]n \"G[func_]\" que act\[UAcute]a sobre una \
funci\[OAcute]n \"func\"",
  " y la convierte en la funci\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`\(G[func]\)[x] = Sin[x] + 5\ Cos[func[1.0 - x]]\)]],
  ".  Partiendo de la funci\[OAcute]n identidad \"Identity\" itera la funci\
\[OAcute]n G 5 veces. Representa gr\[AAcute]ficamente las funciones as\
\[IAcute] obtenidas en el intervalo [-1,1]. \[DownQuestion]Converge la sucesi\
\[OAcute]n de iteradas as\[IAcute] definida?"
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Iteraciones de Picard", "Section"],

Cell[TextData[{
  "Se trata de hallar una funci\[OAcute]n, ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", definida en un intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " con derivada continua y que verifique la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`x' \((t)\) = f \((t, x \((t)\))\)\)]],
  "  para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] I\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`x(a) = \[Alpha]\)]],
  ". Suponemos que ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es una funci\[OAcute]n conocida de dos variables suficientemente buena y \
que ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " es un punto de ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  ". La ecuaci\[OAcute]n anterior puede escribirse de forma equivalente como:\
\n\t\t\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(x(t)\), " ", "=", " ", 
          RowBox[{"\[Alpha]", " ", "+", 
            RowBox[{
              
              FormBox[\(\ 
                \[Integral]\_a\%t\( f(s, x(s))\) \[DifferentialD]s\),
                "TraditionalForm"], "  \t", \((t \[Element] I)\)}]}]}], 
        TraditionalForm]]],
  "\nLo que nos dice que la funci\[OAcute]n ",
  StyleBox["x",
    FontSlant->"Italic"],
  " es un punto fijo de la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`G\  : \ C(I)\  \[RightArrow] \ C(I)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "que a cada funci\[OAcute]n",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`x\  \[Element] \ C(I)\)]],
  " hace corresponder la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`G(x) \[Element] \ C(I)\)]],
  "  definida por ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(G(x)\) \((t)\)\), " ", "=", " ", 
          RowBox[{"\[Alpha]", " ", "+", 
            FormBox[\(\ \[Integral]\_a\%t\( f(s, x(s))\) \[DifferentialD]s\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] I\)]],
  StyleBox[", ",
    FontSlant->"Italic"],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`C \((I)\)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es el espacio de las funciones continuas en",
  StyleBox[" I. ",
    FontSlant->"Italic"],
  "Siguiendo la analog\[IAcute]a con el caso num\[EAcute]rico, podemos partir \
de una funci\[OAcute]n inicial ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1 \[Element] C(I)\)]],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1 = \[Alpha]\)]],
  ", y formar la sucesi\[OAcute]n de funciones ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(n + 1\) = G(x\_n)\)]],
  ". Esto se conoce como ",
  StyleBox["m\[EAcute]todo de las iteraciones de Picard ",
    FontSlant->"Italic"],
  "para resolver el problema de valores iniciales dado."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsubsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Dado un problema de valores iniciales ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((x)\) = f(x, y(x)), \ y(a) = \[Alpha]\)]],
  ", define la sucesi\[OAcute]n de las iteradas de Picard partiendo de la \
funci\[OAcute]n inicial constante igual a \[Alpha]. \nSugerencia. No olvides \
hacer la definici\[OAcute]n de forma que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " recuerde las iteradas que ha calculado.\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  "Calcula las primeras 5 iteradas de Picard para los problemas de valores \
iniciales:\n",
  Cell[BoxData[
      \(TraditionalForm\`y' = x + Sin[x] + \ 9  y\ /10\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ y(0) = 1\)\)]],
  " \n",
  Cell[BoxData[
      \(TraditionalForm\`y' = x + 1/3\ y\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y(1/2) = 1/2\)]],
  "\n",
  Cell[BoxData[
      \(TraditionalForm\`y' = x\ Exp[x] + 5  y\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = 1\)]],
  "\nEn cada caso calcula la soluci\[OAcute]n exacta con el comando \
\"DSolve\". Elige intervalos apropiados para representar gr\[AAcute]ficamente \
las iteradas obtenidas en cada caso y comp\[AAcute]ralas con la soluci\
\[OAcute]n exacta. En el \[UAcute]ltimo caso puedes calcular m\[AAcute]s \
iteradas para estudiar si hay convergencia. Comenta los resultados \
obtenidos."
}], "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1152}, {0, 799}},
WindowSize->{1106, 707},
WindowMargins->{{2, Automatic}, {Automatic, 5}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 40, 0, 81, "Title"],

Cell[CellGroupData[{
Cell[1774, 53, 61, 0, 83, "Section"],
Cell[1838, 55, 738, 14, 119, "Text"],

Cell[CellGroupData[{
Cell[2601, 73, 36, 0, 55, "Subsubsection"],
Cell[2640, 75, 1617, 35, 285, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4306, 116, 40, 0, 83, "Section"],
Cell[4349, 118, 2873, 88, 249, "Text"],

Cell[CellGroupData[{
Cell[7247, 210, 36, 0, 55, "Subsubsection"],
Cell[7286, 212, 1440, 39, 339, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

